/* 
 * File:   WM8731.h
 * Author: User
 *
 * Created on 10 September 2013, 1:42 PM
 */

#ifndef WM8731_H
#define	WM8731_H

#ifdef	__cplusplus
extern "C" {
#endif

void WM8731_Setup_Control_SPI();
void WM8731_Send_Control_SPI_Message(unsigned short data);

typedef enum { Line_Input, Microphone } WM8731_Input_To_ADC;
typedef enum { Right_Justified_MSB_First, Left_Justified_MSB_First, I2S, DSP_Mode } WM8731_Digital_Audio_Format;
typedef enum { Left_When_LRC_High, Right_When_LRC_High } WM8731_Left_Right_Phase;
typedef enum { Slave_Mode, Master_Mode } WM8731_Mode;
typedef enum { false, true } boolean;

void WM8731_Set_Left_Line_In_Vol(signed short dB, boolean mute, boolean lrinboth);
void WM8731_Set_Right_Line_In_Vol(signed short dB, boolean mute, boolean lrinboth);
void WM8731_Set_Left_Headphone_Out_Vol(signed short dB, boolean zcen, boolean lrhpboth);
void WM8731_Set_Right_Headphone_Out_Vol(signed short dB, boolean zcen, boolean lrhpboth);
void WM8731_Set_Analog_Audio_Path(boolean micboost, boolean micmute, WM8731_Input_To_ADC adc_input, boolean bypass_enable, boolean dac_enable, boolean sidetone_enable, signed char sidetone_atten_db);
void WM8731_Set_Digital_Audio_Path(boolean adc_high_pass_filter_enable, unsigned short deemphasis_sampling_rate, boolean dac_soft_mute_enable, boolean high_pass_filter_disabled_store_dc_offset);
void WM8731_Power_Control(boolean enable_line_input, boolean enable_mic_input_bias, boolean enable_adc, boolean enable_dac, boolean enable_outputs, boolean enable_oscillator, boolean enable_clkout, boolean poweroff);
void WM8731_Set_Digital_Audio_Interface_Format(WM8731_Digital_Audio_Format format, unsigned char data_bit_length, WM8731_Left_Right_Phase lrp, boolean dac_left_right_swap, WM8731_Mode mode, boolean invert_bclk);
void WM8731_Sampling_Control(unsigned short oversampling_rate, unsigned long adc_sampling_rate, unsigned long dac_sampling_rate, boolean mclk_divide_by_two, boolean clkout_divide_by_two);
void WM8731_Enable_MCU_Interface(boolean enable);
void WM8731_Reset();

#ifdef	__cplusplus
}
#endif

#endif	/* WM8731_H */

